<?php
include 'config.php';

$logFile = 'ip_log.json';
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$now = time();
$WINDOW = 30 * 60; 
$MAX = 4;


$data = [];
if (file_exists($logFile)) {
    $data = json_decode(file_get_contents($logFile), true);
    if (!is_array($data)) $data = [];
}

if (!isset($data[$ip]) || !is_array($data[$ip])) $data[$ip] = [];
$data[$ip] = array_values(array_filter($data[$ip], function($t) use ($now, $WINDOW) {
    return ($t >= $now - $WINDOW);
}));

if (count($data[$ip]) >= $MAX) {
    http_response_code(429);
    die("Only {$MAX} requests allowed per 30 minutes");
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['type']) || trim($_POST['type']) !== 'requestxstrong') {
        echo json_encode(["error" => "Invalid request"]);
        exit;
    }

    $name   = isset($_POST['name']) ? trim($_POST['name']) : '';
    $method = isset($_POST['method']) ? trim($_POST['method']) : '';
    $number = isset($_POST['number']) ? trim($_POST['number']) : '';
    $amount = isset($_POST['amount']) ? trim($_POST['amount']) : '';
    $trxid  = isset($_POST['trxid']) ? trim($_POST['trxid']) : '';
    $fcm    = isset($_POST['fcm']) ? trim($_POST['fcm']) : '';
    $email = trim($_POST['email']);
    $password = $_POST['password'];

$rscaptain_stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ?");
$rscaptain_stmt->bind_param("ss", $email, $password);
$rscaptain_stmt->execute();
$rs_result = $rscaptain_stmt->get_result();

if ($rs_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    $rscaptain_stmt->close();
    $conn->close();
    exit();
}
$rscaptain_stmt->close();

    if (empty($name) || empty($email) || empty($password) || empty($method) || empty($number) || empty($amount) || empty($trxid) || empty($fcm)) {
        echo json_encode(["error" => "All fields are required"]);
        exit;
    }

    $date = date("d-M-Y");
    $time = date("h:i:s A");

    $sql = "INSERT INTO addmoney (name, email, method, number, amount, trxid, date, time, fcm) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssss", $name, $email, $method, $number, $amount, $trxid, $date, $time, $fcm);

    if ($stmt->execute()) {
        echo "Request Successfully";
        $ipLog[$ipAddress] = $currentTime;
        file_put_contents($logFile, json_encode($ipLog));
    } else {
        echo json_encode(["error" => "Error Requesting: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["error" => "Invalid Request Method"]);
}
?>